/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armorstatues.api.client.gui.components.TickingButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreenFactory;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractArmorStandScreen
extends Screen
implements MenuAccess<ArmorStandMenu>,
ArmorStandScreen {
    private static final ResourceLocation ARMOR_STAND_BACKGROUND_LOCATION = new ResourceLocation("armorstatues", "textures/gui/container/armor_stand/background.png");
    public static final ResourceLocation ARMOR_STAND_WIDGETS_LOCATION = new ResourceLocation("armorstatues", "textures/gui/container/armor_stand/widgets.png");
    protected final int imageWidth = 210;
    protected final int imageHeight = 188;
    protected final ArmorStandHolder holder;
    private final Inventory inventory;
    protected final DataSyncHandler dataSyncHandler;
    protected int leftPos;
    protected int topPos;
    protected int inventoryEntityX;
    protected int inventoryEntityY;
    protected boolean smallInventoryEntity;
    protected int mouseX;
    protected int mouseY;
    private AbstractWidget closeButton;

    public AbstractArmorStandScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(component);
        this.holder = holder;
        this.inventory = inventory;
        this.dataSyncHandler = dataSyncHandler;
    }

    @Override
    public ArmorStandHolder getHolder() {
        return this.holder;
    }

    @Override
    public <T extends Screen & ArmorStandScreen> T createScreenType(ArmorStandScreenType screenType) {
        Object screen = ArmorStandScreenFactory.createScreenType(screenType, this.holder, this.inventory, this.f_96539_, this.dataSyncHandler);
        ((ArmorStandScreen)screen).setMouseX(this.mouseX);
        ((ArmorStandScreen)screen).setMouseY(this.mouseY);
        return screen;
    }

    @Override
    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    @Override
    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    public void m_86600_() {
        super.m_86600_();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof TickingButton)) continue;
            TickingButton button = (TickingButton)child;
            button.tick();
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.withCloseButton()) {
            this.closeButton = (AbstractWidget)this.m_142416_((GuiEventListener)AbstractArmorStandScreen.makeCloseButton(this, this.leftPos, this.imageWidth, this.topPos));
        }
    }

    public static AbstractButton makeCloseButton(Screen screen, int leftPos, int imageWidth, int topPos) {
        return new ImageButton(leftPos + imageWidth - 15 - 8, topPos + 8, 15, 15, 136, 0, ARMOR_STAND_WIDGETS_LOCATION, button -> screen.m_7379_());
    }

    protected boolean withCloseButton() {
        return true;
    }

    protected boolean renderInventoryEntity() {
        return true;
    }

    protected boolean disableMenuRendering() {
        return false;
    }

    protected void toggleMenuRendering(boolean disableMenuRendering) {
        this.closeButton.f_93624_ = !disableMenuRendering;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.disableMenuRendering() && AbstractArmorStandScreen.handleTabClicked((int)mouseX, (int)mouseY, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.tabs())) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.disableMenuRendering()) {
            this.m_7333_(poseStack);
        }
        this.renderBg(poseStack, partialTick, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (!this.disableMenuRendering()) {
            AbstractArmorStandScreen.findHoveredTab(this.leftPos, this.topPos, this.imageHeight, mouseX, mouseY, this.dataSyncHandler.tabs()).ifPresent(hoveredTab -> this.m_96602_(poseStack, hoveredTab.getComponent(), mouseX, mouseY));
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        if (!this.disableMenuRendering()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARMOR_STAND_BACKGROUND_LOCATION);
            this.m_93228_(poseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            AbstractArmorStandScreen.drawTabs(poseStack, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.tabs());
            this.renderEntityInInventory(poseStack);
        }
    }

    private void renderEntityInInventory(PoseStack poseStack) {
        if (this.renderInventoryEntity()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARMOR_STAND_WIDGETS_LOCATION);
            if (this.smallInventoryEntity) {
                this.m_93228_(poseStack, this.leftPos + this.inventoryEntityX, this.topPos + this.inventoryEntityY, 200, 184, 50, 72);
                InventoryScreen.m_98850_((int)(this.leftPos + this.inventoryEntityX + 24), (int)(this.topPos + this.inventoryEntityY + 65), (int)30, (float)(this.leftPos + this.inventoryEntityX + 24 - 10 - this.mouseX), (float)(this.topPos + this.inventoryEntityY + 65 - 44 - this.mouseY), (LivingEntity)this.holder.getArmorStand());
            } else {
                this.m_93228_(poseStack, this.leftPos + this.inventoryEntityX, this.topPos + this.inventoryEntityY, 0, 0, 76, 108);
                InventoryScreen.m_98850_((int)(this.leftPos + this.inventoryEntityX + 38), (int)(this.topPos + this.inventoryEntityY + 98), (int)45, (float)((float)(this.leftPos + this.inventoryEntityX + 38 - 5) - (float)this.mouseX), (float)((float)(this.topPos + this.inventoryEntityY + 98 - 66) - (float)this.mouseY), (LivingEntity)this.holder.getArmorStand());
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean mouseReleased = false;
        for (GuiEventListener child : this.m_6702_()) {
            UnboundedSliderButton sliderButton;
            if (!(child instanceof UnboundedSliderButton) || !(sliderButton = (UnboundedSliderButton)child).isDirty()) continue;
            mouseReleased |= child.m_6348_(mouseX, mouseY, button);
        }
        return mouseReleased || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return AbstractArmorStandScreen.handleMouseScrolled((int)mouseX, (int)mouseY, delta, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.tabs());
    }

    public static <T extends Screen> boolean handleMouseScrolled(int mouseX, int mouseY, double delta, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> optional;
        if ((delta = Math.signum(delta)) != 0.0 && (optional = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs)).isPresent()) {
            ArmorStandScreenType screenType = AbstractArmorStandScreen.cycleTabs(((ArmorStandScreen)screen).getScreenType(), ((ArmorStandScreen)screen).getHolder().getDataProvider().getScreenTypes(), delta > 0.0);
            return AbstractArmorStandScreen.openTabScreen(screen, screenType, false);
        }
        return false;
    }

    public static <T extends Screen> boolean handleTabClicked(int mouseX, int mouseY, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> hoveredTab = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs);
        return hoveredTab.filter(armorStandScreenType -> AbstractArmorStandScreen.openTabScreen(screen, armorStandScreenType, true)).isPresent();
    }

    private static <T extends Screen> boolean openTabScreen(T screen, ArmorStandScreenType screenType, boolean clickSound) {
        if (screenType != ((ArmorStandScreen)screen).getScreenType()) {
            Minecraft minecraft = ClientCoreServices.SCREENS.getMinecraft(screen);
            if (clickSound) {
                minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
            minecraft.m_91152_(((ArmorStandScreen)screen).createScreenType(screenType));
            return true;
        }
        return false;
    }

    private static ArmorStandScreenType cycleTabs(ArmorStandScreenType currentScreenType, ArmorStandScreenType[] screenTypes, boolean backwards) {
        int index = ArrayUtils.indexOf((Object[])screenTypes, (Object)currentScreenType);
        return screenTypes[((backwards ? --index : ++index) % screenTypes.length + screenTypes.length) % screenTypes.length];
    }

    public static <T extends Screen> void drawTabs(PoseStack poseStack, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            ArmorStandScreenType tabType = tabs[i];
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ARMOR_STAND_WIDGETS_LOCATION);
            screen.m_93228_(poseStack, tabX, tabY, 212, tabType == ((ArmorStandScreen)screen).getScreenType() ? 0 : 27, 35, 26);
            ItemRenderer itemRenderer = ClientCoreServices.SCREENS.getItemRenderer(screen);
            itemRenderer.f_115093_ = 100.0f;
            itemRenderer.m_115203_(tabType.getIcon(), tabX + 10, tabY + 5);
            itemRenderer.f_115093_ = 0.0f;
        }
    }

    public static Optional<ArmorStandScreenType> findHoveredTab(int leftPos, int topPos, int imageHeight, int mouseX, int mouseY, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            if (mouseX <= tabX || mouseX > tabX + 32 || mouseY <= tabY || mouseY > tabY + 26) continue;
            return Optional.of(tabs[i]);
        }
        return Optional.empty();
    }

    private static int getTabsStartY(int imageHeight, int tabsCount) {
        int tabsHeight = tabsCount * 26 + (tabsCount - 1);
        return (imageHeight - tabsHeight) / 2;
    }

    public ArmorStandMenu getMenu() {
        return (ArmorStandMenu)this.holder;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.holder instanceof AbstractContainerMenu) {
            this.f_96541_.f_91074_.m_6915_();
        }
        super.m_7379_();
    }
}

